--> pralable
-- USE BD_Air_France;

CREATE TABLE T_avions_AF_taf
 (taf_immat CHAR(6), taf_typavi VARCHAR(10), taf_hvol DECIMAL(10,2));
GO

CREATE TABLE T_avions_SING_tsg
(tsg_nav CHAR(6), tsg_typavi CHAR(10), tsg_prix_achat DECIMAL(14,2));
GO

INSERT INTO T_avions_AF_taf VALUES ('F-WTSS', 'Concorde', 6570.50);
INSERT INTO T_avions_AF_taf VALUES ('F-GLFS', 'A320', 3500.80);
INSERT INTO T_avions_AF_taf VALUES ('F-GTMP', 'A340', NULL);

INSERT INTO T_avions_SING_tsg VALUES ('S-ANSI', 'A320', 104500.70);
INSERT INTO T_avions_SING_tsg VALUES ('S-AVEZ', 'A320', 156000.90);
INSERT INTO T_avions_SING_tsg VALUES ('S-MILE', 'A330', 198000.50);
INSERT INTO T_avions_SING_tsg VALUES ('F-GTMP', 'A340', 204500);

--INTERSECT 

SELECT   taf_typavi FROM T_avions_AF_taf
INTERSECT 
SELECT   CAST(tsg_typavi AS VARCHAR(10)) FROM T_avions_SING_tsg;

SELECT taf_immat, taf_typavi FROM T_avions_AF_taf
INTERSECT 
SELECT tsg_nav,CAST(tsg_typavi AS VARCHAR(10)) FROM T_avions_SING_tsg;

SELECT   qlf_brevet FROM T_qualifs_qlf WHERE avi_typavi='A320'
INTERSECT 
SELECT   qlf_brevet FROM T_qualifs_qlf WHERE avi_typavi='A340';

SELECT   qlf_brevet FROM T_qualifs_qlf 
WHERE avi_typavi='A320' AND qlf_annee = 2009
INTERSECT 
SELECT   qlf_brevet FROM T_qualifs_qlf WHERE avi_typavi='A340'
AND qlf_annee = 2009;

--UNION 

SELECT   taf_typavi FROM T_avions_AF_taf
UNION 
SELECT   CAST(tsg_typavi AS VARCHAR(10)) FROM T_avions_SING_tsg;

SELECT   taf_immat, taf_typavi FROM T_avions_AF_taf
UNION ALL
SELECT   tsg_nav,CAST(tsg_typavi AS VARCHAR(10)) FROM T_avions_SING_tsg;
  
-- EXCEPT

SELECT   taf_typavi FROM T_avions_AF_taf
EXCEPT
SELECT   CAST(tsg_typavi AS VARCHAR(10)) FROM T_avions_SING_tsg;

SELECT  CAST(tsg_typavi AS VARCHAR(10)) AS "tsg_typavi" FROM T_avions_SING_tsg
EXCEPT
SELECT   taf_typavi FROM T_avions_AF_taf;

-- NULL

INSERT INTO T_avions_AF_taf VALUES ('F-NUL1', NULL, 3800);
INSERT INTO T_avions_SING_tsg VALUES ('F-NUL2', NULL, 245000.0);

SELECT distinct  taf_typavi FROM T_avions_AF_taf;
SELECT  distinct tsg_typavi FROM T_avions_SING_tsg;

SELECT   taf_typavi FROM T_avions_AF_taf
INTERSECT 
SELECT   CAST(tsg_typavi AS VARCHAR(10)) FROM T_avions_SING_tsg;

--ordre

SELECT   taf_immat, taf_typavi  FROM T_avions_AF_taf
UNION ALL
SELECT   tsg_nav,CAST(tsg_typavi AS VARCHAR(10)) FROM T_avions_SING_tsg
ORDER BY taf_immat DESC;

SELECT   taf_immat, taf_typavi  FROM T_avions_AF_taf
UNION ALL
SELECT   tsg_nav,CAST(tsg_typavi AS VARCHAR(10)) FROM T_avions_SING_tsg
ORDER BY 1 DESC;

SELECT   taf_immat ti, taf_typavi FROM T_avions_AF_taf
UNION ALL
SELECT   tsg_nav,CAST(tsg_typavi AS VARCHAR(10)) FROM T_avions_SING_tsg
ORDER BY ti DESC;
  
--Ajout colonnes

SELECT  tsg_nav, 1.2*tsg_prix_achat AS "prix" FROM T_avions_SING_tsg WHERE tsg_typavi IS NOT NULL
UNION
SELECT  taf_immat, 0 FROM T_avions_AF_taf WHERE taf_typavi IS NOT NULL
ORDER BY 2 DESC;

--produit cartsien

CREATE TABLE T_pilote_pil
(pil_brevet VARCHAR(6) CONSTRAINT pk_Pilote PRIMARY KEY,
  pil_prenom VARCHAR(16), pil_nom VARCHAR(16), pil_hvol DECIMAL(7,2), compa VARCHAR(4));

INSERT INTO T_pilote_pil VALUES ('PL-1', 'Pascal','Brunini',4500, 'AF');
INSERT INTO T_pilote_pil VALUES ('PL-2', 'Richard','Grin', 10020, 'SING');
INSERT INTO T_pilote_pil VALUES ('PL-3', 'Placide', 'Fresnais',12450, 'CAST');
INSERT INTO T_pilote_pil VALUES ('PL-4', 'Daniel','Vielle', 5900, 'AF');

SELECT p.pil_brevet, af.taf_immat, af.taf_typavi
FROM   T_pilote_pil p, T_avions_AF_taf af
WHERE  p.compa   = 'AF'
AND    af.taf_typavi IS NOT NULL
AND    af.taf_immat  IS NOT NULL;

SELECT     p.pil_brevet, af.taf_immat, af.taf_typavi
FROM       T_pilote_pil p
CROSS JOIN T_avions_AF_taf af
WHERE      p.compa   = 'AF'
AND        af.taf_typavi IS NOT NULL
AND       af.taf_immat  IS NOT NULL;


DROP TABLE T_avions_SING_tsg 
GO

DROP TABLE T_qualifs_qlf;
GO

DROP TABLE T_pilote_pil ;
GO

DROP TABLE T_avions_AF_taf;
GO








